<?php
/**
 * Uninstall WPAP Card Helper
 *
 * Fires when the plugin is uninstalled.
 */

// If uninstall not called from WordPress, exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('wpap_replacer_settings');

// Delete all transients created by the plugin
global $wpdb;

// Delete token transient
delete_transient('wpap_replacer_token');

// Delete all product cache transients
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s",
        '_transient_wpap_product_%',
        '_transient_timeout_wpap_product_%'
    )
);

// Delete all wpap_replacer transients
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s",
        '_transient_wpap_replacer_%',
        '_transient_timeout_wpap_replacer_%'
    )
);
