/**
 * Gutenberg Block: Amazon商品カード
 */

(function (blocks, element, editor, components, i18n) {
    var el = element.createElement;
    var registerBlockType = blocks.registerBlockType;
    var TextControl = components.TextControl;
    var InspectorControls = editor.InspectorControls;
    var PanelBody = components.PanelBody;

    registerBlockType('wpap-card-helper/product-card', {
        title: 'Amazon商品カード',
        icon: 'cart',
        category: 'embed',
        attributes: {
            asin: {
                type: 'string',
                default: ''
            },
            title: {
                type: 'string',
                default: ''
            }
        },

        edit: function (props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;
            var useState = element.useState;
            var fetching = useState(false)[0];
            var setFetching = useState(false)[1];

            function onChangeASIN(newASIN) {
                setAttributes({ asin: newASIN });
            }

            function onChangeTitle(newTitle) {
                setAttributes({ title: newTitle });
            }

            function fetchTitle() {
                var asin = attributes.asin;

                if (!asin) {
                    alert('ASINを入力してください');
                    return;
                }

                setFetching(true);

                fetch(wpApiSettings.root + 'wpap-card-helper/v1/scrape-title/' + asin, {
                    method: 'GET',
                    headers: {
                        'X-WP-Nonce': wpApiSettings.nonce
                    }
                })
                    .then(function (response) {
                        return response.json();
                    })
                    .then(function (data) {
                        if (data.success && data.data && data.data.title) {
                            setAttributes({ title: data.data.title });
                        } else {
                            alert('タイトルが取得できませんでした');
                        }
                    })
                    .catch(function (error) {
                        alert('エラー: ' + error.message);
                    })
                    .finally(function () {
                        setFetching(false);
                    });
            }

            return el(
                'div',
                { className: 'wpap-card-block-editor' },
                el(
                    InspectorControls,
                    {},
                    el(
                        PanelBody,
                        { title: '商品カード設定', initialOpen: true },
                        el(TextControl, {
                            label: 'ASIN',
                            value: attributes.asin,
                            onChange: onChangeASIN,
                            help: 'Amazonの商品識別コード（10桁）'
                        }),
                        el(
                            components.Button,
                            {
                                isSecondary: true,
                                isBusy: fetching,
                                disabled: fetching || !attributes.asin,
                                onClick: fetchTitle,
                                style: { marginTop: '10px', marginBottom: '10px', width: '100%' }
                            },
                            fetching ? '取得中...' : 'タイトルを取得'
                        ),
                        el(TextControl, {
                            label: '商品名（任意）',
                            value: attributes.title,
                            onChange: onChangeTitle,
                            help: 'APIを使用しない場合に表示される商品名'
                        })
                    )
                ),
                el(
                    'div',
                    {
                        style: {
                            border: '2px dashed #ccc',
                            padding: '20px',
                            textAlign: 'center',
                            background: '#f9f9f9',
                            borderRadius: '4px'
                        }
                    },
                    el('span', { className: 'dashicons dashicons-cart', style: { fontSize: '48px', color: '#666' } }),
                    el('h3', { style: { marginTop: '10px' } }, 'Amazon商品カード'),
                    attributes.asin
                        ? el('p', {}, 'ASIN: ' + attributes.asin)
                        : el('p', { style: { color: '#999' } }, 'サイドバーからASINを入力してください'),
                    attributes.title && el('p', { style: { fontSize: '12px', color: '#666' } }, '商品名: ' + attributes.title)
                )
            );
        },

        save: function () {
            // 動的レンダリングを使用するため null を返す
            return null;
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.editor,
    window.wp.components,
    window.wp.i18n
);
